// ThreeDOM.js - http://github.com/mrdoob/three.js
'use strict';var THREE=THREE||{REVISION:"48"};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"];if(!window.requestAnimationFrame)window.requestAnimationFrame=function(b){var c=(new Date).getTime(),f=Math.max(0,16-(c-a)),g=window.setTimeout(function(){b(c+f)},f);a=c+f;return g};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=
function(a){clearTimeout(a)}})();THREE.Color=function(a){void 0!==a&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);
this.b=Math.sqrt(this.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,f;if(0===c)this.r=this.g=this.b=0;else switch(d=Math.floor(6*a),e=6*a-d,a=c*(1-b),f=c*(1-b*e),b=c*(1-b*(1-e)),d){case 1:this.r=f;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=f;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=f;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=
Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return Math.floor(255*this.r)<<16^Math.floor(255*this.g)<<8^Math.floor(255*this.b)},getContextStyle:function(){return"rgb("+Math.floor(255*this.r)+","+Math.floor(255*this.g)+","+Math.floor(255*this.b)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;return this},equals:function(a){return a.x===this.x&&a.y===this.y},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;return this},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.x=c*a.z-d*a.y;this.y=d*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},getPositionFromMatrix:function(a){this.x=
a.n14;this.y=a.n24;this.z=a.n34;return this},getRotationFromMatrix:function(a,b){var c=b?b.x:1,d=b?b.y:1,e=b?b.z:1,f=a.n11/c,g=a.n12/d,c=a.n21/c,d=a.n22/d,h=a.n23/e,k=a.n33/e;this.y=Math.asin(a.n13/e);e=Math.cos(this.y);1.0E-5<Math.abs(e)?(this.x=Math.atan2(-h/e,k/e),this.z=Math.atan2(-g/e,f/e)):(this.x=0,this.z=Math.atan2(c,d));return this},getScaleFromMatrix:function(a){var b=this.set(a.n11,a.n21,a.n31).length(),c=this.set(a.n12,a.n22,a.n32).length(),a=this.set(a.n13,a.n23,a.n33).length();this.x=
b;this.y=c;this.z=a},equals:function(a){return a.x===this.x&&a.y===this.y&&a.z===this.z},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=void 0!==a.w?a.w:1;return this},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;
this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Frustum=function(){this.planes=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4]};
THREE.Frustum.prototype.setFromMatrix=function(a){var b,c=this.planes;c[0].set(a.n41-a.n11,a.n42-a.n12,a.n43-a.n13,a.n44-a.n14);c[1].set(a.n41+a.n11,a.n42+a.n12,a.n43+a.n13,a.n44+a.n14);c[2].set(a.n41+a.n21,a.n42+a.n22,a.n43+a.n23,a.n44+a.n24);c[3].set(a.n41-a.n21,a.n42-a.n22,a.n43-a.n23,a.n44-a.n24);c[4].set(a.n41-a.n31,a.n42-a.n32,a.n43-a.n33,a.n44-a.n34);c[5].set(a.n41+a.n31,a.n42+a.n32,a.n43+a.n33,a.n44+a.n34);for(a=0;6>a;a++)b=c[a],b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))};
THREE.Frustum.prototype.contains=function(a){for(var b=this.planes,c=a.matrixWorld,d=THREE.Frustum.__v1.set(c.getColumnX().length(),c.getColumnY().length(),c.getColumnZ().length()),d=-a.geometry.boundingSphere.radius*Math.max(d.x,Math.max(d.y,d.z)),e=0;6>e;e++)if(a=b[e].x*c.n14+b[e].y*c.n24+b[e].z*c.n34+b[e].w,a<=d)return!1;return!0};THREE.Frustum.__v1=new THREE.Vector3;
THREE.Ray=function(a,b){function c(a,b,c){p.sub(c,a);G=p.dot(b);v=o.add(a,q.copy(b).multiplyScalar(G));return C=c.distanceTo(v)}function d(a,b,c,d){p.sub(d,b);o.sub(c,b);q.sub(a,b);D=p.dot(p);r=p.dot(o);z=p.dot(q);t=o.dot(o);x=o.dot(q);H=1/(D*t-r*r);K=(t*z-r*x)*H;E=(D*x-r*z)*H;return 0<=K&&0<=E&&1>K+E}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;this.intersectObjects=function(a){var b,c,d=[];for(b=0,c=a.length;b<c;b++)Array.prototype.push.apply(d,this.intersectObject(a[b]));
d.sort(function(a,b){return a.distance-b.distance});return d};var e=1.0E-4;this.setPrecision=function(a){e=a};var f=new THREE.Vector3,g=new THREE.Vector3,h=new THREE.Vector3,k=new THREE.Vector3,i=new THREE.Vector3,j=new THREE.Vector3,l=new THREE.Vector3,n=new THREE.Vector3,m=new THREE.Vector3;this.intersectObject=function(a){var b,o=[];if(a instanceof THREE.Particle){var p=c(this.origin,this.direction,a.matrixWorld.getPosition());if(p>a.scale.x)return[];b={distance:p,point:a.position,face:null,object:a};
o.push(b)}else if(a instanceof THREE.Mesh){var p=c(this.origin,this.direction,a.matrixWorld.getPosition()),q=THREE.Frustum.__v1.set(a.matrixWorld.getColumnX().length(),a.matrixWorld.getColumnY().length(),a.matrixWorld.getColumnZ().length());if(p>a.geometry.boundingSphere.radius*Math.max(q.x,Math.max(q.y,q.z)))return o;var r,t,v=a.geometry,A=v.vertices,u;a.matrixRotationWorld.extractRotation(a.matrixWorld);for(p=0,q=v.faces.length;p<q;p++)if(b=v.faces[p],i.copy(this.origin),j.copy(this.direction),
u=a.matrixWorld,l=u.multiplyVector3(l.copy(b.centroid)).subSelf(i),n=a.matrixRotationWorld.multiplyVector3(n.copy(b.normal)),r=j.dot(n),!(Math.abs(r)<e)&&(t=n.dot(l)/r,!(0>t)&&(a.doubleSided||(a.flipSided?0<r:0>r))))if(m.add(i,j.multiplyScalar(t)),b instanceof THREE.Face3)f=u.multiplyVector3(f.copy(A[b.a].position)),g=u.multiplyVector3(g.copy(A[b.b].position)),h=u.multiplyVector3(h.copy(A[b.c].position)),d(m,f,g,h)&&(b={distance:i.distanceTo(m),point:m.clone(),face:b,object:a},o.push(b));else if(b instanceof
THREE.Face4&&(f=u.multiplyVector3(f.copy(A[b.a].position)),g=u.multiplyVector3(g.copy(A[b.b].position)),h=u.multiplyVector3(h.copy(A[b.c].position)),k=u.multiplyVector3(k.copy(A[b.d].position)),d(m,f,g,k)||d(m,g,h,k)))b={distance:i.distanceTo(m),point:m.clone(),face:b,object:a},o.push(b)}return o};var p=new THREE.Vector3,o=new THREE.Vector3,q=new THREE.Vector3,G,v,C,D,r,z,t,x,H,K,E};
THREE.Rectangle=function(){function a(){f=d-b;g=e-c}var b,c,d,e,f,g,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return f};this.getHeight=function(){return g};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,j,l){h=!1;b=f;c=g;d=j;e=l;a()};this.addPoint=function(f,g){h?(h=!1,b=f,c=g,d=f,e=g):(b=b<f?b:f,c=c<g?c:g,d=d>f?d:f,e=e>g?e:g);a()};this.add3Points=
function(f,g,j,l,n,m){h?(h=!1,b=f<j?f<n?f:n:j<n?j:n,c=g<l?g<m?g:m:l<m?l:m,d=f>j?f>n?f:n:j>n?j:n,e=g>l?g>m?g:m:l>m?l:m):(b=f<j?f<n?f<b?f:b:n<b?n:b:j<n?j<b?j:b:n<b?n:b,c=g<l?g<m?g<c?g:c:m<c?m:c:l<m?l<c?l:c:m<c?m:c,d=f>j?f>n?f>d?f:d:n>d?n:d:j>n?j>d?j:d:n>d?n:d,e=g>l?g>m?g>e?g:e:m>e?m:e:l>m?l>e?l:e:m>e?m:e);a()};this.addRectangle=function(f){h?(h=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.intersects=function(a){return d<a.getLeft()||b>a.getRight()||e<a.getTop()||c>a.getBottom()?!1:!0};this.empty=function(){h=!0;e=d=c=b=0;a()};this.isEmpty=function(){return h}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,d,e){return d+(a-b)*(e-d)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*(0.5-Math.random())},sign:function(a){return 0>a?-1:0<a?1:0}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,e,f,g,h,k,i,j,l,n,m,p,o){this.set(void 0!==a?a:1,b||0,c||0,d||0,e||0,void 0!==f?f:1,g||0,h||0,k||0,i||0,void 0!==j?j:1,l||0,n||0,m||0,p||0,void 0!==o?o:1);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,f,g,h,k,i,j,l,n,m,p,o){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=f;this.n23=g;this.n24=h;this.n31=k;this.n32=i;this.n33=j;this.n34=l;this.n41=n;this.n42=m;this.n43=p;this.n44=o;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,f=THREE.Matrix4.__v3;f.sub(a,b).normalize();if(0===f.length())f.z=1;d.cross(c,f).normalize();0===d.length()&&(f.x+=1.0E-4,d.cross(c,f).normalize());e.cross(f,d);this.n11=d.x;this.n12=e.x;this.n13=f.x;this.n21=d.y;this.n22=e.y;this.n23=f.y;this.n31=d.z;this.n32=e.z;this.n33=f.z;return this},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,f=a.n14,g=a.n21,h=a.n22,k=a.n23,i=a.n24,j=a.n31,l=a.n32,n=a.n33,m=a.n34,p=a.n41,o=a.n42,q=a.n43,G=a.n44,v=b.n11,
C=b.n12,D=b.n13,r=b.n14,z=b.n21,t=b.n22,x=b.n23,H=b.n24,K=b.n31,E=b.n32,J=b.n33,P=b.n34,Q=b.n41,R=b.n42,S=b.n43,T=b.n44;this.n11=c*v+d*z+e*K+f*Q;this.n12=c*C+d*t+e*E+f*R;this.n13=c*D+d*x+e*J+f*S;this.n14=c*r+d*H+e*P+f*T;this.n21=g*v+h*z+k*K+i*Q;this.n22=g*C+h*t+k*E+i*R;this.n23=g*D+h*x+k*J+i*S;this.n24=g*r+h*H+k*P+i*T;this.n31=j*v+l*z+n*K+m*Q;this.n32=j*C+l*t+n*E+m*R;this.n33=j*D+l*x+n*J+m*S;this.n34=j*r+l*H+n*P+m*T;this.n41=p*v+o*z+q*K+G*Q;this.n42=p*C+o*t+q*E+G*R;this.n43=p*D+o*x+q*J+G*S;this.n44=
p*r+o*H+q*P+G*T;return this},multiplySelf:function(a){return this.multiply(this,a)},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;
this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*
d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+
this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,f=this.n22,g=this.n23,h=this.n24,k=this.n31,i=this.n32,j=this.n33,l=this.n34,n=this.n41,m=this.n42,p=this.n43,o=this.n44;return d*g*i*n-c*h*i*n-d*f*j*n+b*h*j*n+c*f*l*n-b*g*l*n-d*g*k*m+c*h*k*m+d*e*j*m-a*h*j*m-c*e*l*m+a*g*l*m+d*f*k*p-b*h*k*p-d*e*i*p+a*h*i*p+b*e*l*p-a*f*l*p-c*f*k*o+b*g*k*o+c*e*i*o-a*g*i*o-b*e*j*o+a*f*j*o},transpose:function(){var a;
a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n34=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;
a.n43=this.n43;a.n44=this.n44;return a},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+
10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=
Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,f=a.x,g=a.y,h=a.z,k=e*f,i=e*g;this.set(k*f+c,k*g-d*h,k*h+d*g,0,k*g+d*h,i*g+c,i*h-d*f,0,k*h-d*g,i*h+d*f,e*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){return THREE.Matrix4.__v1.set(this.n14,this.n24,this.n34)},getColumnX:function(){return THREE.Matrix4.__v1.set(this.n11,
this.n21,this.n31)},getColumnY:function(){return THREE.Matrix4.__v1.set(this.n12,this.n22,this.n32)},getColumnZ:function(){return THREE.Matrix4.__v1.set(this.n13,this.n23,this.n33)},getInverse:function(a){var b=a.n11,c=a.n12,d=a.n13,e=a.n14,f=a.n21,g=a.n22,h=a.n23,k=a.n24,i=a.n31,j=a.n32,l=a.n33,n=a.n34,m=a.n41,p=a.n42,o=a.n43,q=a.n44;this.n11=h*n*p-k*l*p+k*j*o-g*n*o-h*j*q+g*l*q;this.n12=e*l*p-d*n*p-e*j*o+c*n*o+d*j*q-c*l*q;this.n13=d*k*p-e*h*p+e*g*o-c*k*o-d*g*q+c*h*q;this.n14=e*h*j-d*k*j-e*g*l+c*
k*l+d*g*n-c*h*n;this.n21=k*l*m-h*n*m-k*i*o+f*n*o+h*i*q-f*l*q;this.n22=d*n*m-e*l*m+e*i*o-b*n*o-d*i*q+b*l*q;this.n23=e*h*m-d*k*m-e*f*o+b*k*o+d*f*q-b*h*q;this.n24=d*k*i-e*h*i+e*f*l-b*k*l-d*f*n+b*h*n;this.n31=g*n*m-k*j*m+k*i*p-f*n*p-g*i*q+f*j*q;this.n32=e*j*m-c*n*m-e*i*p+b*n*p+c*i*q-b*j*q;this.n33=c*k*m-e*g*m+e*f*p-b*k*p-c*f*q+b*g*q;this.n34=e*g*i-c*k*i-e*f*j+b*k*j+c*f*n-b*g*n;this.n41=h*j*m-g*l*m-h*i*p+f*l*p+g*i*o-f*j*o;this.n42=c*l*m-d*j*m+d*i*p-b*l*p-c*i*o+b*j*o;this.n43=d*g*m-c*h*m-d*f*p+b*h*p+c*
f*o-b*g*o;this.n44=c*h*i-d*g*i+d*f*j-b*h*j-c*f*l+b*g*l;this.multiplyScalar(1/a.determinant());return this},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,f=Math.cos(c),c=Math.sin(c),g=Math.cos(d),d=Math.sin(d),h=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var k=g*h,i=g*e,j=d*h,l=d*e;this.n11=k+l*c;this.n12=j*c-i;this.n13=f*d;this.n21=f*e;this.n22=f*h;this.n23=-c;this.n31=i*c-j;this.n32=l+k*c;this.n33=f*g;break;case "ZXY":k=g*h;i=g*e;j=d*h;l=d*e;this.n11=k-l*c;this.n12=-f*e;this.n13=j+
i*c;this.n21=i+j*c;this.n22=f*h;this.n23=l-k*c;this.n31=-f*d;this.n32=c;this.n33=f*g;break;case "ZYX":k=f*h;i=f*e;j=c*h;l=c*e;this.n11=g*h;this.n12=j*d-i;this.n13=k*d+l;this.n21=g*e;this.n22=l*d+k;this.n23=i*d-j;this.n31=-d;this.n32=c*g;this.n33=f*g;break;case "YZX":k=f*g;i=f*d;j=c*g;l=c*d;this.n11=g*h;this.n12=l-k*e;this.n13=j*e+i;this.n21=e;this.n22=f*h;this.n23=-c*h;this.n31=-d*h;this.n32=i*e+j;this.n33=k-l*e;break;case "XZY":k=f*g;i=f*d;j=c*g;l=c*d;this.n11=g*h;this.n12=-e;this.n13=d*h;this.n21=
k*e+l;this.n22=f*h;this.n23=i*e-j;this.n31=j*e-i;this.n32=c*h;this.n33=l*e+k;break;default:k=f*h,i=f*e,j=c*h,l=c*e,this.n11=g*h,this.n12=-g*e,this.n13=d,this.n21=i+j*d,this.n22=k-l*d,this.n23=-c*g,this.n31=l-k*d,this.n32=j+i*d,this.n33=f*g}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,f=b+b,g=c+c,h=d+d,a=b*f,k=b*g,b=b*h,i=c*g,c=c*h,d=d*h,f=e*f,g=e*g,e=e*h;this.n11=1-(i+d);this.n12=k-e;this.n13=b+g;this.n21=k+e;this.n22=1-(a+d);this.n23=c-f;this.n31=b-g;this.n32=c+
f;this.n33=1-(a+i);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,e=THREE.Matrix4.__m2;d.identity();d.setRotationFromQuaternion(b);e.setScale(c.x,c.y,c.z);this.multiply(d,e);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,
f=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);e.set(this.n12,this.n22,this.n32);f.set(this.n13,this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();c.y=e.length();c.z=f.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);
return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34;return this},extractRotation:function(a){var b=THREE.Matrix4.__v1,c=1/b.set(a.n11,a.n21,a.n31).length(),d=1/b.set(a.n12,a.n22,a.n32).length(),b=1/b.set(a.n13,a.n23,a.n33).length();this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*b;this.n23=a.n23*b;this.n33=a.n33*b;return this},rotateByAxis:function(a,b){if(1===a.x&&0===a.y&&0===a.z)return this.rotateX(b);
if(0===a.x&&1===a.y&&0===a.z)return this.rotateY(b);if(0===a.x&&0===a.y&&1===a.z)return this.rotateZ(b);var c=a.x,d=a.y,e=a.z,f=Math.sqrt(c*c+d*d+e*e),c=c/f,d=d/f,e=e/f,f=c*c,g=d*d,h=e*e,k=Math.cos(b),i=Math.sin(b),j=1-k,l=c*d*j,n=c*e*j,j=d*e*j,c=c*i,m=d*i,i=e*i,e=f+(1-f)*k,f=l+i,d=n-m,l=l-i,g=g+(1-g)*k,i=j+c,n=n+m,j=j-c,h=h+(1-h)*k,k=this.n11,c=this.n21,m=this.n31,p=this.n41,o=this.n12,q=this.n22,G=this.n32,v=this.n42,C=this.n13,D=this.n23,r=this.n33,z=this.n43;this.n11=e*k+f*o+d*C;this.n21=e*c+
f*q+d*D;this.n31=e*m+f*G+d*r;this.n41=e*p+f*v+d*z;this.n12=l*k+g*o+i*C;this.n22=l*c+g*q+i*D;this.n32=l*m+g*G+i*r;this.n42=l*p+g*v+i*z;this.n13=n*k+j*o+h*C;this.n23=n*c+j*q+h*D;this.n33=n*m+j*G+h*r;this.n43=n*p+j*v+h*z;return this},rotateX:function(a){var b=this.n12,c=this.n22,d=this.n32,e=this.n42,f=this.n13,g=this.n23,h=this.n33,k=this.n43,i=Math.cos(a),a=Math.sin(a);this.n12=i*b+a*f;this.n22=i*c+a*g;this.n32=i*d+a*h;this.n42=i*e+a*k;this.n13=i*f-a*b;this.n23=i*g-a*c;this.n33=i*h-a*d;this.n43=i*
k-a*e;return this},rotateY:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,f=this.n13,g=this.n23,h=this.n33,k=this.n43,i=Math.cos(a),a=Math.sin(a);this.n11=i*b-a*f;this.n21=i*c-a*g;this.n31=i*d-a*h;this.n41=i*e-a*k;this.n13=i*f+a*b;this.n23=i*g+a*c;this.n33=i*h+a*d;this.n43=i*k+a*e;return this},rotateZ:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,f=this.n12,g=this.n22,h=this.n32,k=this.n42,i=Math.cos(a),a=Math.sin(a);this.n11=i*b+a*f;this.n21=i*c+a*g;this.n31=i*d+a*h;this.n41=
i*e+a*k;this.n12=i*f-a*b;this.n22=i*g-a*c;this.n32=i*h-a*d;this.n42=i*k-a*e;return this},translate:function(a){var b=a.x,c=a.y,a=a.z;this.n14=this.n11*b+this.n12*c+this.n13*a+this.n14;this.n24=this.n21*b+this.n22*c+this.n23*a+this.n24;this.n34=this.n31*b+this.n32*c+this.n33*a+this.n34;this.n44=this.n41*b+this.n42*c+this.n43*a+this.n44;return this}};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,f=a.n32*a.n21-a.n31*a.n22,g=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,k=-a.n32*a.n11+a.n31*a.n12,i=a.n23*a.n12-a.n22*a.n13,j=-a.n23*a.n11+a.n21*a.n13,l=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*g+a.n31*i;if(0===a)return null;a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*f;c[3]=a*g;c[4]=a*h;c[5]=a*k;c[6]=a*i;c[7]=a*j;c[8]=a*l;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,f){var g;g=new THREE.Matrix4;g.n11=2*e/(b-a);g.n12=0;g.n13=(b+a)/(b-a);g.n14=0;g.n21=0;g.n22=2*e/(d-c);g.n23=(d+c)/(d-c);g.n24=0;g.n31=0;g.n32=0;g.n33=-(f+e)/(f-e);g.n34=-2*f*e/(f-e);g.n41=0;g.n42=0;g.n43=-1;g.n44=0;return g};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,f){var g,h,k,i;g=new THREE.Matrix4;h=b-a;k=c-d;i=f-e;g.n11=2/h;g.n12=0;g.n13=0;g.n14=-((b+a)/h);g.n21=0;g.n22=2/k;g.n23=0;g.n24=-((c+d)/k);g.n31=0;g.n32=0;g.n33=-2/i;g.n34=-((f+e)/i);g.n41=0;g.n42=0;g.n43=0;g.n44=1;return g};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,applyMatrix:function(a){this.matrix.multiply(a,this.matrix);this.scale.getScaleFromMatrix(this.matrix);this.rotation.getRotationFromMatrix(this.matrix,this.scale);this.position.getPositionFromMatrix(this.matrix)},translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,
this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)},add:function(a){if(a===this)console.warn("THREE.Object3D.add: An object can't be added as a child of itself.");else if(-1===this.children.indexOf(a)){void 0!==a.parent&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.__addObject(a)}},remove:function(a){var b=
this.children.indexOf(a);if(-1!==b){a.parent=void 0;this.children.splice(b,1);for(b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.__removeObject(a)}},getChildByName:function(a,b){var c,d,e;for(c=0,d=this.children.length;c<d;c++){e=this.children[c];if(e.name===a||b&&(e=e.getChildByName(a,b),void 0!==e))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,
this.eulerOrder);if(1!==this.scale.x||1!==this.scale.y||1!==this.scale.z)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,a=!0;for(var b=0,c=this.children.length;b<
c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=g[f]=g[f]||new THREE.RenderableObject;f++;return a}function b(){var a=i[k]=i[k]||new THREE.RenderableVertex;k++;return a}function c(a,b){return b.z-a.z}function d(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;if(0<=e&&0<=f&&0<=g&&0<=h)return!0;if(0>e&&0>f||0>g&&0>h)return!1;0>e?c=Math.max(c,e/(e-f)):0>f&&(d=Math.min(d,e/(e-f)));0>g?c=Math.max(c,g/(g-h)):0>h&&(d=Math.min(d,g/(g-h)));if(d<c)return!1;a.lerpSelf(b,c);b.lerpSelf(a,1-d);return!0}
var e,f,g=[],h,k,i=[],j,l,n=[],m,p=[],o,q,G=[],v,C,D=[],r={objects:[],sprites:[],lights:[],elements:[]},z=new THREE.Vector3,t=new THREE.Vector4,x=new THREE.Matrix4,H=new THREE.Matrix4,K=new THREE.Frustum,E=new THREE.Vector4,J=new THREE.Vector4;this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);x.multiply(b.projectionMatrix,b.matrixWorldInverse);x.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);x.multiply(b.matrixWorld,
b.projectionMatrixInverse);x.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,d){f=0;r.objects.length=0;r.sprites.length=0;r.lights.length=0;var g=function(b){if(!1!==b.visible){(b instanceof THREE.Mesh||b instanceof THREE.Line)&&(!1===b.frustumCulled||K.contains(b))?(x.multiplyVector3(z.copy(b.position)),e=a(),e.object=
b,e.z=z.z,r.objects.push(e)):b instanceof THREE.Sprite||b instanceof THREE.Particle?(x.multiplyVector3(z.copy(b.position)),e=a(),e.object=b,e.z=z.z,r.sprites.push(e)):b instanceof THREE.Light&&r.lights.push(b);for(var c=0,d=b.children.length;c<d;c++)g(b.children[c])}};g(b);d&&r.objects.sort(c);return r};this.projectScene=function(a,e,f){var g=e.near,z=e.far,N=!1,U,A,u,I,s,B,y,F,w,L,M,X,V,W,O;C=q=m=l=0;r.elements.length=0;void 0===e.parent&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),
a.add(e));a.updateMatrixWorld();e.matrixWorldInverse.getInverse(e.matrixWorld);x.multiply(e.projectionMatrix,e.matrixWorldInverse);K.setFromMatrix(x);r=this.projectGraph(a,!1);for(a=0,U=r.objects.length;a<U;a++)if(w=r.objects[a].object,L=w.matrixWorld,k=0,w instanceof THREE.Mesh){M=w.geometry;X=w.geometry.materials;I=M.vertices;V=M.faces;W=M.faceVertexUvs;M=w.matrixRotationWorld.extractRotation(L);for(A=0,u=I.length;A<u;A++)h=b(),h.positionWorld.copy(I[A].position),L.multiplyVector3(h.positionWorld),
h.positionScreen.copy(h.positionWorld),x.multiplyVector4(h.positionScreen),h.positionScreen.x/=h.positionScreen.w,h.positionScreen.y/=h.positionScreen.w,h.visible=h.positionScreen.z>g&&h.positionScreen.z<z;for(I=0,A=V.length;I<A;I++){u=V[I];if(u instanceof THREE.Face3)if(s=i[u.a],B=i[u.b],y=i[u.c],s.visible&&B.visible&&y.visible)if(N=0>(y.positionScreen.x-s.positionScreen.x)*(B.positionScreen.y-s.positionScreen.y)-(y.positionScreen.y-s.positionScreen.y)*(B.positionScreen.x-s.positionScreen.x),w.doubleSided||
N!=w.flipSided)F=n[l]=n[l]||new THREE.RenderableFace3,l++,j=F,j.v1.copy(s),j.v2.copy(B),j.v3.copy(y);else continue;else continue;else if(u instanceof THREE.Face4)if(s=i[u.a],B=i[u.b],y=i[u.c],F=i[u.d],s.visible&&B.visible&&y.visible&&F.visible)if(N=0>(F.positionScreen.x-s.positionScreen.x)*(B.positionScreen.y-s.positionScreen.y)-(F.positionScreen.y-s.positionScreen.y)*(B.positionScreen.x-s.positionScreen.x)||0>(B.positionScreen.x-y.positionScreen.x)*(F.positionScreen.y-y.positionScreen.y)-(B.positionScreen.y-
y.positionScreen.y)*(F.positionScreen.x-y.positionScreen.x),w.doubleSided||N!=w.flipSided)O=p[m]=p[m]||new THREE.RenderableFace4,m++,j=O,j.v1.copy(s),j.v2.copy(B),j.v3.copy(y),j.v4.copy(F);else continue;else continue;j.normalWorld.copy(u.normal);!N&&(w.flipSided||w.doubleSided)&&j.normalWorld.negate();M.multiplyVector3(j.normalWorld);j.centroidWorld.copy(u.centroid);L.multiplyVector3(j.centroidWorld);j.centroidScreen.copy(j.centroidWorld);x.multiplyVector3(j.centroidScreen);y=u.vertexNormals;for(s=
0,B=y.length;s<B;s++)F=j.vertexNormalsWorld[s],F.copy(y[s]),!N&&(w.flipSided||w.doubleSided)&&F.negate(),M.multiplyVector3(F);for(s=0,B=W.length;s<B;s++)if(O=W[s][I])for(y=0,F=O.length;y<F;y++)j.uvs[s][y]=O[y];j.material=w.material;j.faceMaterial=null!==u.materialIndex?X[u.materialIndex]:null;j.z=j.centroidScreen.z;r.elements.push(j)}}else if(w instanceof THREE.Line){H.multiply(x,L);I=w.geometry.vertices;s=b();s.positionScreen.copy(I[0].position);H.multiplyVector4(s.positionScreen);for(A=1,u=I.length;A<
u;A++)if(s=b(),s.positionScreen.copy(I[A].position),H.multiplyVector4(s.positionScreen),B=i[k-2],E.copy(s.positionScreen),J.copy(B.positionScreen),d(E,J))E.multiplyScalar(1/E.w),J.multiplyScalar(1/J.w),L=G[q]=G[q]||new THREE.RenderableLine,q++,o=L,o.v1.positionScreen.copy(E),o.v2.positionScreen.copy(J),o.z=Math.max(E.z,J.z),o.material=w.material,r.elements.push(o)}for(a=0,U=r.sprites.length;a<U;a++)if(w=r.sprites[a].object,L=w.matrixWorld,w instanceof THREE.Particle&&(t.set(L.n14,L.n24,L.n34,1),x.multiplyVector4(t),
t.z/=t.w,0<t.z&&1>t.z))g=D[C]=D[C]||new THREE.RenderableParticle,C++,v=g,v.x=t.x/t.w,v.y=t.y/t.w,v.z=t.z,v.rotation=w.rotation.z,v.scale.x=w.scale.x*Math.abs(v.x-(t.x+e.projectionMatrix.n11)/(t.w+e.projectionMatrix.n14)),v.scale.y=w.scale.y*Math.abs(v.y-(t.y+e.projectionMatrix.n22)/(t.w+e.projectionMatrix.n24)),v.material=w.material,r.elements.push(v);f&&r.elements.sort(c);return r}};THREE.Quaternion=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},clone:function(){return new THREE.Quaternion(this.x,this.y,this.z,this.w)},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),f=Math.cos(c),c=Math.sin(c),g=a*b,h=d*e;this.w=g*f-h*c;this.x=g*c+h*f;this.y=d*b*f+a*e*c;this.z=a*e*
f-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=0>a.n32-a.n23?-Math.abs(this.x):Math.abs(this.x);this.y=0>a.n13-a.n31?
-Math.abs(this.y):Math.abs(this.y);this.z=0>a.n21-a.n12?-Math.abs(this.z):Math.abs(this.z);this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);0===a?this.w=this.z=
this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,f=a.x,g=a.y,h=a.z,a=a.w;this.x=b*a+e*f+c*h-d*g;this.y=c*a+e*g+d*f-b*h;this.z=d*a+e*h+b*g-c*f;this.w=e*a-b*f-c*g-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=
a);var c=a.x,d=a.y,e=a.z,f=this.x,g=this.y,h=this.z,k=this.w,i=k*c+g*e-h*d,j=k*d+h*c-f*e,l=k*e+f*d-g*c,c=-f*c-g*d-h*e;b.x=i*k+c*-f+j*-h-l*-g;b.y=j*k+c*-g+l*-f-i*-h;b.z=l*k+c*-h+i*-g-j*-f;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;0>e?(c.w=-b.w,c.x=-b.x,c.y=-b.y,c.z=-b.z,e=-e):c.copy(b);if(1<=Math.abs(e))return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var f=Math.acos(e),e=Math.sqrt(1-e*e);if(0.001>Math.abs(e))return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;b=Math.sin((1-d)*f)/e;d=Math.sin(d*f)/e;c.w=a.w*b+c.w*d;c.x=a.x*b+c.x*d;c.y=a.y*b+c.y*d;c.z=a.z*b+c.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Vertex.prototype={constructor:THREE.Vertex,clone:function(){return new THREE.Vertex(this.position.clone())}};THREE.Face3=function(a,b,c,d,e,f){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materialIndex=f;this.centroid=new THREE.Vector3};
THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){var a=new THREE.Face3(this.a,this.b,this.c);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;for(b=0,c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();for(b=0,c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();for(b=0,c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.Face4=function(a,b,c,d,e,f,g){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materialIndex=g;this.centroid=new THREE.Vector3};
THREE.Face4.prototype={constructor:THREE.Face4,clone:function(){var a=new THREE.Face4(this.a,this.b,this.c,this.d);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;for(b=0,c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();for(b=0,c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();for(b=0,c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},lerpSelf:function(a,b){this.u+=(a.u-this.u)*b;this.v+=(a.v-this.v)*b;return this},clone:function(){return new THREE.UV(this.u,this.v)}};THREE.Camera=function(){THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};
THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)};THREE.OrthographicCamera=function(a,b,c,d,e,f){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=void 0!==e?e:0.1;this.far=void 0!==f?f:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;
THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=void 0!==a?a:50;this.aspect=void 0!==b?b:1;this.near=void 0!==c?c:0.1;this.far=void 0!==d?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;
THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((void 0!==b?b:24)/(2*a))*(180/Math.PI);this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,e,f){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=f;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,
this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;
THREE.Material=function(a){a=a||{};this.id=THREE.MaterialCount++;this.name="";this.opacity=void 0!==a.opacity?a.opacity:1;this.transparent=void 0!==a.transparent?a.transparent:!1;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.depthTest=void 0!==a.depthTest?a.depthTest:!0;this.depthWrite=void 0!==a.depthWrite?a.depthWrite:!0;this.polygonOffset=void 0!==a.polygonOffset?a.polygonOffset:!1;this.polygonOffsetFactor=void 0!==a.polygonOffsetFactor?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
void 0!==a.polygonOffsetUnits?a.polygonOffsetUnits:0;this.alphaTest=void 0!==a.alphaTest?a.alphaTest:0;this.overdraw=void 0!==a.overdraw?a.overdraw:!1};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NoBlending=0;THREE.NormalBlending=1;THREE.AdditiveBlending=2;THREE.SubtractiveBlending=3;THREE.MultiplyBlending=4;THREE.AdditiveAlphaBlending=5;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=void 0!==a.linewidth?a.linewidth:1;this.linecap=void 0!==a.linecap?a.linecap:"round";this.linejoin=void 0!==a.linejoin?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:
!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.size=void 0!==a.size?a.size:1;this.sizeAttenuation=void 0!==a.sizeAttenuation?a.sizeAttenuation:!0;this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleDOMMaterial=function(a){THREE.Material.call(this);this.domElement=a};
THREE.Texture=function(a,b,c,d,e,f,g,h){this.id=THREE.TextureCount++;this.image=a;this.mapping=void 0!==b?b:new THREE.UVMapping;this.wrapS=void 0!==c?c:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==d?d:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==e?e:THREE.LinearFilter;this.minFilter=void 0!==f?f:THREE.LinearMipMapLinearFilter;this.format=void 0!==g?g:THREE.RGBAFormat;this.type=void 0!==h?h:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=
!0;this.needsUpdate=!1;this.onUpdate=null};THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter,this.format,this.type);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};
THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;
THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(a,b,c,d,e,f,g,h,k,i){THREE.Texture.call(this,null,f,g,h,k,i,d,e);this.image={data:a,width:b,height:c}};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var a=new THREE.DataTexture(this.image.data,this.image.width,this.image.height,this.format,this.type,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=void 0!==b?b:new THREE.MeshBasicMaterial({color:16777215*Math.random(),wireframe:!0});if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),
this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(void 0!==this.morphTargetDictionary[a])return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=void 0!==b?b:new THREE.LineBasicMaterial({color:16777215*Math.random()});this.type=void 0!==c?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};
THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var c,d=this.children.length;for(c=0;c<d;c++)this.children[c].update(this.skinMatrix,b)};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:new THREE.Texture;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.useScreenCoordinates=void 0!==a.useScreenCoordinates?a.useScreenCoordinates:!0;this.mergeWith3D=void 0!==a.mergeWith3D?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=void 0!==a.affectedByDistance?a.affectedByDistance:!this.useScreenCoordinates;
this.scaleByViewport=void 0!==a.scaleByViewport?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(1!==this.scale.x||1!==this.scale.y)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);
THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=!1;this.__objects=[];this.__lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.__addObject=function(a){if(a instanceof THREE.Light)-1===this.__lights.indexOf(a)&&this.__lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&-1===this.__objects.indexOf(a)){this.__objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);-1!==b&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.__addObject(a.children[b])};
THREE.Scene.prototype.__removeObject=function(a){if(a instanceof THREE.Light){var b=this.__lights.indexOf(a);-1!==b&&this.__lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.__objects.indexOf(a),-1!==b&&(this.__objects.splice(b,1),this.__objectsRemoved.push(a),b=this.__objectsAdded.indexOf(a),-1!==b&&this.__objectsAdded.splice(b,1)));for(b=0;b<a.children.length;b++)this.__removeObject(a.children[b])};
THREE.DOMRenderer=function(){var a,b,c=new THREE.Projector,d,e,f,g;this.domElement=document.createElement("div");this.setSize=function(a,b){d=a;e=b;f=d/2;g=e/2};this.render=function(d,e){var i,j,l,n,m;a=c.projectScene(d,e);b=a.elements;for(i=0,j=b.length;i<j;i++)if(l=b[i],l instanceof THREE.RenderableParticle&&(n=l.x*f+f,m=l.y*g+g,l=l.material,l instanceof THREE.ParticleDOMMaterial))l=l.domElement,l.style.left=n+"px",l.style.top=m+"px"}};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};THREE.RenderableObject=function(){this.z=this.object=null};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.material=null};
